// EasyHotKey DLL SOURCE. Modified by ISI360, based on original code from wolf9228.
// https://www.autoitscript.com/forum/topic/127682-dll-global-setwindowshookex/

#include <shlobj.h>
#include <windows.h>
#include <stdio.h>

static int OkTestExeHwnd = 99999;
static HINSTANCE ihinstDLL = 0;
static HWND ExeHwnd = 0;
static UINT KEYBOARD_MSG,MOUSE_MSG,HOOK_GUI_MSG;
static HHOOK HHOOK_MAIN_Keyboard,HHOOK_MAIN_Mouse,HHOOK_THREAD_Keyboard,HHOOK_THREAD_Mouse;

LRESULT CALLBACK WINAPI KeyboardProc(int nCode,WPARAM wParam,LPARAM lParam);
LRESULT CALLBACK WINAPI MouseProc(int nCode,WPARAM wParam,LPARAM lParam);

HWND GetExeHwnd();

#ifdef __cplusplus
extern "C"
{
#endif
__declspec(dllexport) HHOOK WINAPI DllWindowsHookExW(UINT idHook, UINT Thread);
__declspec(dllexport) BOOL WINAPI DllGetModuleFileNameW(LPWSTR &iMsgBuffer);
#ifdef __cplusplus
}
#endif

extern "C"
BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{
    switch (fdwReason)
    {
    case DLL_PROCESS_ATTACH:
        ihinstDLL = hinstDLL;
        WCHAR MsgBuffer[32767];
        GetModuleFileNameW((HMODULE) hinstDLL,MsgBuffer,sizeof(MsgBuffer));
        HOOK_GUI_MSG = RegisterWindowMessageW(MsgBuffer);       
        KEYBOARD_MSG = RegisterWindowMessageW(L"KEYBOARD_MSG");
        MOUSE_MSG = RegisterWindowMessageW(L"MOUSE_MSG");
      
        break;
    case DLL_PROCESS_DETACH:
        if (HHOOK_MAIN_Keyboard) UnhookWindowsHookEx(HHOOK_MAIN_Keyboard);
        if (HHOOK_MAIN_Mouse) UnhookWindowsHookEx(HHOOK_MAIN_Mouse);		
        if (HHOOK_THREAD_Keyboard) UnhookWindowsHookEx(HHOOK_THREAD_Keyboard);
        if (HHOOK_THREAD_Mouse) UnhookWindowsHookEx(HHOOK_THREAD_Mouse);
        break;
    case DLL_THREAD_ATTACH:
        break;
    case DLL_THREAD_DETACH:
        break;
    }
    return TRUE;
}


HHOOK WINAPI DllWindowsHookExW(UINT idHook, UINT Thread)
{

switch(	idHook )
{

case WH_KEYBOARD:
	if (!(HHOOK_MAIN_Keyboard))
	{
	HHOOK_MAIN_Keyboard = SetWindowsHookExW(idHook,KeyboardProc,ihinstDLL,Thread);
	if (HHOOK_MAIN_Keyboard) return HHOOK_MAIN_Keyboard;
	} else {
	HHOOK_THREAD_Keyboard = SetWindowsHookExW(idHook,KeyboardProc,ihinstDLL,Thread);
	if (HHOOK_THREAD_Keyboard) return HHOOK_THREAD_Keyboard;
	}
	break;

case WH_MOUSE:
	if (!(HHOOK_MAIN_Mouse))
	{
	HHOOK_MAIN_Mouse = SetWindowsHookExW(idHook,MouseProc,ihinstDLL,Thread);
	if (HHOOK_MAIN_Mouse) return HHOOK_MAIN_Mouse;
	} else {
	HHOOK_THREAD_Mouse = SetWindowsHookExW(idHook,MouseProc,ihinstDLL,Thread);
	if (HHOOK_THREAD_Mouse) return HHOOK_THREAD_Mouse;
	}
	break;

default:
	return 0;
}

return 0;
}


BOOL WINAPI DllGetModuleFileNameW(LPWSTR &iMsgBuffer)
{
if (GetModuleFileNameW((HMODULE) ihinstDLL,iMsgBuffer,600) != 0) return 1;
return 0;
}


LRESULT CALLBACK WINAPI KeyboardProc(int nCode,WPARAM wParam,LPARAM lParam)
{

if (!(ExeHwnd)) ExeHwnd = GetExeHwnd();
if (!(ExeHwnd)) return CallNextHookEx(0,nCode,wParam,lParam);

SendMessage(ExeHwnd,KEYBOARD_MSG,1,GetCurrentProcessId());
SendMessage(ExeHwnd,KEYBOARD_MSG,2,nCode);
SendMessage(ExeHwnd,KEYBOARD_MSG,3,wParam);

INT RT = SendMessage(ExeHwnd,KEYBOARD_MSG,4,lParam);
if (RT)
{
return RT;
} else {
return CallNextHookEx(0,nCode,wParam,lParam);
}

}

LRESULT CALLBACK WINAPI MouseProc(int nCode,WPARAM wParam,LPARAM lParam)
{

if (!(ExeHwnd)) ExeHwnd = GetExeHwnd();
if (!(ExeHwnd)) return CallNextHookEx(0,nCode,wParam,lParam);

SendMessage(ExeHwnd,MOUSE_MSG,1,GetCurrentProcessId());
SendMessage(ExeHwnd,MOUSE_MSG,2,nCode);
SendMessage(ExeHwnd,MOUSE_MSG,3,wParam);
INT RT = SendMessage(ExeHwnd,MOUSE_MSG,4,lParam);
if (RT)
{
return RT;
} else {
return CallNextHookEx(0,nCode,wParam,lParam);
}

}


HWND GetExeHwnd()
{

HWND hwnd = NULL;
do
{
hwnd = FindWindowEx(NULL,hwnd,NULL,NULL);
if ((int) SendMessage(hwnd,HOOK_GUI_MSG,0,0) == OkTestExeHwnd) return hwnd;
}
while (hwnd != NULL);

return 0;

}


